#include <X11/Xlib.h>
#include <X11/Xft/Xft.h>
#include <string.h>
#include <stdlib.h>
#include <admin.h>
#include <types.h>
#include <data.h>
#include <unistd.h>
#include <stdio.h>
#include <auth.h>

#define MAX_LINE_LENGTH 256

Button adminbtn = {
    20, 20, 100, 100, "Admin"};

void redraw(Display *d, Window w, GC gc,
            XftDraw *xftdraw, XftFont *font, XftColor xftColor)
{
    SysInfo sys = {0};
    char buffer[SYSINFO_STRLEN];

    draw_button(d, w, gc, xftdraw, font, &xftColor, &adminbtn);

    /* Hostname */
    gethostname(sys.hostname, SYSINFO_STRLEN);

    /* OS info */
    read_os_release(&sys);

    removeChar(sys.os_pretty_name, '"');
    removeChar(sys.os_version, '"');

    /* Boot time */
    get_boot_time_string(sys.boot_time, sizeof(sys.boot_time));

    /* Format display strings */
    snprintf(buffer, sizeof(buffer), "OS: %.*s", SYSINFO_STRLEN - 5, sys.os_pretty_name);
    strncpy(sys.os_pretty_name, buffer, SYSINFO_STRLEN);

    snprintf(buffer, sizeof(buffer), "Version: %.*s", SYSINFO_STRLEN - 10, sys.os_version);
    strncpy(sys.os_version, buffer, SYSINFO_STRLEN);

    snprintf(buffer, sizeof(buffer), "Hostname: %.*s", SYSINFO_STRLEN - 11, sys.hostname);
    strncpy(sys.hostname, buffer, SYSINFO_STRLEN);

    snprintf(buffer, sizeof(buffer), "Boot Time: %.*s", SYSINFO_STRLEN - 12, sys.boot_time);
    strncpy(sys.boot_time, buffer, SYSINFO_STRLEN);

    /* Draw text */
    int x = 700;
    int y = 50;
    int line_height = 30;

    XftDrawStringUtf8(xftdraw, &xftColor, font, x, y,
                      (XftChar8 *)sys.os_pretty_name,
                      strlen(sys.os_pretty_name));

    y += line_height;
    XftDrawStringUtf8(xftdraw, &xftColor, font, x, y,
                      (XftChar8 *)sys.os_version,
                      strlen(sys.os_version));

    y += line_height;
    XftDrawStringUtf8(xftdraw, &xftColor, font, x, y,
                      (XftChar8 *)sys.hostname,
                      strlen(sys.hostname));

    y += line_height;
    XftDrawStringUtf8(xftdraw, &xftColor, font, x, y,
                      (XftChar8 *)sys.boot_time,
                      strlen(sys.boot_time));
}

int main()
{

    Display *d = XOpenDisplay(NULL);
    if (!d)
    {
        printf("Cannot open display\n");
        exit(1);
    }

    int s = DefaultScreen(d);

    // Create a black background window
    Window w = XCreateSimpleWindow(
        d, RootWindow(d, s), 100, 100, 1024, 768, 1,
        BlackPixel(d, s), BlackPixel(d, s));

    XSelectInput(d, w, ExposureMask | ButtonPressMask);
    XMapWindow(d, w);
    /* data */
    // White foreground for drawing buttons
    GC gc = XCreateGC(d, w, 0, NULL);
    XSetForeground(d, gc, WhitePixel(d, s));

    XftDraw *xftdraw = XftDrawCreate(d, w,
                                     DefaultVisual(d, s), DefaultColormap(d, s));

    // Load custom font (choose any installed font)
    XftFont *font = XftFontOpenName(d, s, "DejaVu Sans-14");

    // White text color
    XftColor xftColor;
    XRenderColor xr = {0xffff, 0xffff, 0xffff, 0xffff};
    XftColorAllocValue(d, DefaultVisual(d, s),
                       DefaultColormap(d, s), &xr, &xftColor);

    XEvent e;

    while (1)
    {
        XNextEvent(d, &e);

        if (e.type == Expose)
        {
            redraw(d, w, gc, xftdraw, font, xftColor);
        }
        if (e.type == ButtonPress)
        {

            int mx = e.xbutton.x;
            int my = e.xbutton.y;

            if (inside(&adminbtn, mx, my))
            {
                redraw(d, w, gc, xftdraw, font, xftColor);
                if (password_prompt(d, s, w, font, &xftColor))
                {
                    showAdmin(d, w, gc, xftdraw, font, xftColor, s);
                    XClearWindow(d, w);
                    redraw(d, w, gc, xftdraw, font, xftColor);
                }
                else
                {
                    XftDrawStringUtf8(
                        xftdraw,
                        &xftColor,
                        font,
                        adminbtn.x,
                        adminbtn.y + adminbtn.h + 30,
                        (XftChar8 *)"Authentication failed!", 22);
                }
            }
        }
    }
}