#include <stddef.h>
#include <stdio.h>
#include <time.h>
#include <sys/sysinfo.h>
#include <string.h>
#include <types.h>

static void clean_value(char *s)
{
    size_t len = strlen(s);

    // Remove trailing newline
    if (len > 0 && s[len - 1] == '\n')
        s[--len] = '\0';

    // Remove surrounding quotes
    if (len >= 2 && s[0] == '"' && s[len - 1] == '"')
    {
        memmove(s, s + 1, len - 2);
        s[len - 2] = '\0';
    }
}

void removeChar(char *str, char garbage)
{

    char *src, *dst;
    for (src = dst = str; *src != '\0'; src++)
    {
        *dst = *src;
        if (*dst != garbage)
            dst++;
    }
    *dst = '\0';
}

int read_os_release(SysInfo *info)
{
    FILE *f = fopen("/etc/os-release", "r");
    if (!f)
        return -1;

    char line[256];

    memset(line, 0, sizeof(line));
    memset(info->os_pretty_name, 0, SYSINFO_STRLEN);
    memset(info->os_version, 0, SYSINFO_STRLEN);

    // Defaults
    info->os_pretty_name[0] = '\0';
    info->os_version[0] = '\0';

    while (fgets(line, sizeof(line), f))
    {

        if (strncmp(line, "PRETTY_NAME=", 12) == 0)
        {
            strncpy(info->os_pretty_name, line + 12, strlen(line));
            info->os_pretty_name[SYSINFO_STRLEN - 1] = '\0';
            clean_value(info->os_pretty_name);
        }
        else if (strncmp(line, "VERSION=", 8) == 0)
        {
            strncpy(info->os_version, line + 8, strlen(line));

            info->os_version[SYSINFO_STRLEN - 1] = '\0';
            clean_value(info->os_version);
        }
    }

    fclose(f);

    return 0;
}

int get_boot_time_string(char *out, size_t out_size)
{
    if (!out || out_size == 0)
        return -1;

    struct sysinfo info;
    if (sysinfo(&info) != 0)
        return -1;

    time_t now = time(NULL);
    time_t boot_time = now - info.uptime;

    struct tm tm;
    if (!localtime_r(&boot_time, &tm))
        return -1;

    /*
     * Format:
     *   M/D/Y H:M:S AM/PM
     * Example:
     *   12/11/2025 3:42:09 PM
     */
    if (strftime(out, out_size, "%-m/%-d/%Y %-I:%M:%S %p", &tm) == 0)
        return -1;

    return 0;
}