#include <stdio.h>
#include <string.h>
#include <admin.h>
#include <types.h>
#include <stdlib.h>

#define BUTTON_WIDTH 150
#define BUTTON_HEIGHT 150
#define BUTTON_SPACING 20

int inside(Button *b, int x, int y)
{
    return x >= b->x && x <= b->x + b->w &&
           y >= b->y && y <= b->y + b->h;
}

void draw_button(Display *d, Window w, GC gc,
                 XftDraw *xftdraw, XftFont *font, XftColor *color,
                 Button *b)
{

    // Draw button outline
    XDrawRectangle(d, w, gc, b->x, b->y, b->w, b->h);

    // Measure text
    XGlyphInfo extents;
    XftTextExtentsUtf8(d, font,
                       (XftChar8 *)b->label,
                       strlen(b->label),
                       &extents);

    int text_width = extents.xOff;

    // Center coordinates
    int tx = b->x + (b->w - text_width) / 2;
    int ty = b->y + (b->h + font->ascent - font->descent) / 2;

    // Draw centered text
    XftDrawStringUtf8(
        xftdraw,
        color,
        font,
        tx,
        ty,
        (XftChar8 *)b->label,
        strlen(b->label));
}

int showAdmin(Display *d, Window w, GC gc, XftDraw *xftdraw, XftFont *font, XftColor xftColor, int s)
{
    XClearWindow(d, w);

    Button btn1 = {20, 20, BUTTON_WIDTH, BUTTON_HEIGHT, "Update System"};
    Button btn2 = {20, BUTTON_HEIGHT + 20 + BUTTON_SPACING, BUTTON_WIDTH, BUTTON_HEIGHT, "Shutdown"};
    Button btn3 = {20, (BUTTON_HEIGHT * 2) + 20 + (BUTTON_SPACING * 2), BUTTON_WIDTH, BUTTON_HEIGHT, "Reboot"};
    Button btn4 = {1024 - (BUTTON_WIDTH - 20), 768 - (BUTTON_HEIGHT - 20), BUTTON_WIDTH / 2, BUTTON_HEIGHT / 2, "Back"};

    draw_button(d, w, gc, xftdraw, font, &xftColor, &btn1);
    draw_button(d, w, gc, xftdraw, font, &xftColor, &btn2);
    draw_button(d, w, gc, xftdraw, font, &xftColor, &btn3);
    draw_button(d, w, gc, xftdraw, font, &xftColor, &btn4);

    XEvent e;

    while (1)
    {
        XNextEvent(d, &e);

        if (e.type == Expose)
        {
            draw_button(d, w, gc, xftdraw, font, &xftColor, &btn1);
            draw_button(d, w, gc, xftdraw, font, &xftColor, &btn2);
            draw_button(d, w, gc, xftdraw, font, &xftColor, &btn3);
            draw_button(d, w, gc, xftdraw, font, &xftColor, &btn4);
        }
        if (e.type == ButtonPress)
        {
            int mx = e.xbutton.x;
            int my = e.xbutton.y;

            if (inside(&btn1, mx, my))
            {
                //figure out how to run this command as root
                system("ls");
                break;
            }

            if (inside(&btn2, mx, my))
            {
                system("shutdown -h now");
            }

            if (inside(&btn3, mx, my))
            {
                system("reboot");
            }

            if (inside(&btn4, mx, my))
            {
                break;
            }
        }
    }
    return 0;
}
